<?php
// Initialize the session

session_start();
// Check if the user is logged in, if not then redirect him to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: https://street.menforhealth.org/bame/sign-in.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">

<head>

	<!-- Title -->
	<title>TuckShop</title>

	<!-- Meta -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="author" content="DexignZone">
	<meta name="robots" content="index, follow">

	<meta name="keywords" content="android, ios, mobile, mobile template, mobile app, ui kit, dark layout, app, delivery, ecommerce, material design, mobile, mobile web, order, phonegap, pwa, store, web app, Ombe, coffee app, coffee template, coffee shop, mobile UI, coffee design, app template, responsive design, coffee showcase, style app, trendy app, modern UI, technology, User-Friendly Interface, Coffee Shop App, PWA (Progressive Web App), Mobile Ordering, Coffee Experience, Digital Menu, Innovative Technology, App Development, Coffee Experience, cafe, bootatrap, Bootstrap Framework, UI/UX Design, Coffee Shop Technology, Online Presence, Coffee Shop Website, Cafe Template, Mobile App Design, Web Application, Digital Presence, Bootstrap, caffine">   

	<meta name="description" content="Discover the perfect blend of design and functionality with Ombe, a Coffee Shop Mobile App Template crafted with Bootstrap and enhanced with Progressive Web App (PWA) capabilities. Elevate your coffee shop's online presence with a seamless, responsive, and feature-rich template. Explore a modern design, user-friendly interface, and PWA technology for an immersive mobile experience. Brew success for your coffee shop effortlessly – Ombe is the ideal template to caffeinate your digital presence.">

	<meta property="og:title" content="Ombe- Coffee Shop Mobile App Template (Bootstrap + PWA) | DexignZone">
	<meta property="og:description" content="Discover the perfect blend of design and functionality with Ombe, a Coffee Shop Mobile App Template crafted with Bootstrap and enhanced with Progressive Web App (PWA) capabilities. Elevate your coffee shop's online presence with a seamless, responsive, and feature-rich template. Explore a modern design, user-friendly interface, and PWA technology for an immersive mobile experience. Brew success for your coffee shop effortlessly – Ombe is the ideal template to caffeinate your digital presence.">

	<meta property="og:image" content="../../xhtml/social-image.png">

	<meta name="format-detection" content="telephone=no">

	<meta name="twitter:title" content="Ombe- Coffee Shop Mobile App Template (Bootstrap + PWA) | DexignZone">
	<meta name="twitter:description" content="Discover the perfect blend of design and functionality with Ombe, a Coffee Shop Mobile App Template crafted with Bootstrap and enhanced with Progressive Web App (PWA) capabilities. Elevate your coffee shop's online presence with a seamless, responsive, and feature-rich template. Explore a modern design, user-friendly interface, and PWA technology for an immersive mobile experience. Brew success for your coffee shop effortlessly – Ombe is the ideal template to caffeinate your digital presence.">

	<meta name="twitter:image" content="../../xhtml/social-image.png">
	<meta name="twitter:card" content="summary_large_image">

	<!-- Mobile Specific -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">

	<!-- Favicons Icon -->
	<link rel="shortcut icon" type="image/x-icon" href="assets/images/app-logo/favicon.png">
	
	<!-- PWA Version -->
	<link rel="manifest" href="manifest.json">
    
    <!-- Global CSS -->
	<link href="assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
	<link rel="stylesheet" href="assets/vendor/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.min.css">
	<link rel="stylesheet" href="assets/vendor/swiper/swiper-bundle.min.css">
    
	<!-- Stylesheets -->
    <link rel="stylesheet" type="text/css" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
     <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
	
    <!-- Google Fonts -->
	<link rel="preconnect" href="https://fonts.googleapis.com/">
	<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600;700;800;900&amp;family=Raleway:wght@300;400;500&amp;display=swap" rel="stylesheet">
	
	<style>
    .group-container {
        display: flex;
        flex-direction: column;
        gap: 20px; /* Space between groups */
    }
</style>


</head>   
<body>
<div class="page-wrapper">
    
	<!-- Preloader -->
	<div id="preloader">
		<div class="loader">
			<div class="spinner-border text-primary" role="status">
				<span class="visually-hidden">Loading...</span>
			</div>
		</div>
	</div>
    <!-- Preloader end-->
	
	<!-- Sidebar -->
	<div class="sidebar dz-floting-sidebar">
		<div class="sidebar-header">
			<!--<div class="app-logo">
				<img class="logo-dark" src="" alt="logo">
				<img class="logo-white d-none" src="" alt="logo">
			</div>-->
			<div class="title-bar mb-0">
				<h4 class="title font-w600">Main Menu</h4>
				<a href="javascript:void(0);" class="floating-close"><i class="feather icon-x"></i></a>
			</div>
		</div>
		<ul class="nav navbar-nav">	
			<li>
				<a class="nav-link active" href="index.php">
					<span class="dz-icon">
						<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M3 8.40002V21C3 21.2652 3.10536 21.5196 3.29289 21.7071C3.48043 21.8947 3.73478 22 4 22H20C20.2652 22 20.5196 21.8947 20.7071 21.7071C20.8946 21.5196 21 21.2652 21 21V8.40002C21.0001 8.23638 20.96 8.07523 20.8833 7.93069C20.8066 7.78616 20.6956 7.66265 20.56 7.57102L12.56 2.17102C12.3946 2.05924 12.1996 1.99951 12 1.99951C11.8004 1.99951 11.6054 2.05924 11.44 2.17102L3.44 7.57102C3.30443 7.66265 3.19342 7.78616 3.11671 7.93069C3.03999 8.07523 2.99992 8.23638 3 8.40002V8.40002ZM14 20H10V14H14V20ZM5 8.93202L12 4.20702L19 8.93202V20H16V13C16 12.7348 15.8946 12.4804 15.7071 12.2929C15.5196 12.1054 15.2652 12 15 12H9C8.73478 12 8.48043 12.1054 8.29289 12.2929C8.10536 12.4804 8 12.7348 8 13V20H5V8.93202Z" fill="#BDBDBD"/>
						</svg>
					</span>
					<span>Home</span>
				</a>
			</li>
			<li>
				<a class="nav-link" href="myCredits.php">
					<span class="dz-icon">
						<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M21.733 21.68C21.8274 21.5791 21.8999 21.4598 21.9458 21.3295C21.9918 21.1992 22.0102 21.0608 22 20.923L21 7.923C20.9806 7.67135 20.8667 7.43636 20.6813 7.26517C20.4958 7.09397 20.2524 6.99925 20 7H17C17 5.67392 16.4733 4.40215 15.5356 3.46447C14.5979 2.52678 13.3261 2 12 2C10.674 2 9.40219 2.52678 8.46451 3.46447C7.52682 4.40215 7.00004 5.67392 7.00004 7H4.00004C3.74764 6.99925 3.50429 7.09397 3.31882 7.26517C3.13335 7.43636 3.01947 7.67135 3.00004 7.923L2.00004 20.923C1.98941 21.0607 2.0074 21.199 2.05287 21.3294C2.09834 21.4597 2.17031 21.5793 2.26425 21.6804C2.35819 21.7816 2.47206 21.8622 2.5987 21.9172C2.72533 21.9722 2.86198 22.0004 3.00004 22H21C21.1377 22 21.2738 21.9715 21.3999 21.9165C21.5261 21.8614 21.6395 21.7809 21.733 21.68V21.68ZM12 4C12.7957 4 13.5588 4.31607 14.1214 4.87868C14.684 5.44129 15 6.20435 15 7H9.00004C9.00004 6.20435 9.31611 5.44129 9.87872 4.87868C10.4413 4.31607 11.2044 4 12 4V4ZM4.08004 20L4.92604 9H7.00004V11C7.00004 11.2652 7.1054 11.5196 7.29293 11.7071C7.48047 11.8946 7.73482 12 8.00004 12C8.26526 12 8.51961 11.8946 8.70715 11.7071C8.89468 11.5196 9.00004 11.2652 9.00004 11V9H15V11C15 11.2652 15.1054 11.5196 15.2929 11.7071C15.4805 11.8946 15.7348 12 16 12C16.2653 12 16.5196 11.8946 16.7071 11.7071C16.8947 11.5196 17 11.2652 17 11V9H19.074L19.92 20H4.08004Z" fill="#BDBDBD"/>
						</svg>
					</span>
					<span>My Credits</span>
				</a>
			</li>
			<li>
				<a class="nav-link" href="myCredits.php">
					<span class="dz-icon">
						<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M18 1H6C5.20435 1 4.44129 1.31607 3.87868 1.87868C3.31607 2.44129 3 3.20435 3 4V22C3.00004 22.1978 3.05871 22.391 3.1686 22.5555C3.27848 22.7199 3.43465 22.848 3.61735 22.9237C3.80005 22.9993 4.00108 23.0192 4.19503 22.9806C4.38898 22.942 4.56715 22.8468 4.707 22.707L6.845 20.57L8.168 22.554C8.24932 22.678 8.35719 22.7823 8.48379 22.8594C8.61039 22.9365 8.75256 22.9846 8.9 23C9.04735 23.0156 9.19634 22.9979 9.33588 22.948C9.47542 22.8982 9.60193 22.8175 9.706 22.712L12 20.414L14.293 22.707C14.3977 22.8116 14.5242 22.8916 14.6635 22.9413C14.8029 22.9911 14.9515 23.0093 15.0987 22.9947C15.2459 22.98 15.388 22.9329 15.5149 22.8567C15.6417 22.7805 15.75 22.6771 15.832 22.554L17.155 20.57L19.293 22.707C19.4329 22.8468 19.611 22.942 19.805 22.9806C19.9989 23.0192 20.2 22.9993 20.3827 22.9237C20.5654 22.848 20.7215 22.7199 20.8314 22.5555C20.9413 22.391 21 22.1978 21 22V4C21 3.20435 20.6839 2.44129 20.1213 1.87868C19.5587 1.31607 18.7956 1 18 1V1ZM19 19.586L17.707 18.293C17.603 18.1874 17.4765 18.1066 17.337 18.0568C17.1974 18.0069 17.0484 17.9892 16.901 18.005C16.7539 18.0196 16.6119 18.0666 16.4851 18.1427C16.3584 18.2188 16.2501 18.322 16.168 18.445L14.845 20.43L12.707 18.293C12.5195 18.1055 12.2652 18.0002 12 18.0002C11.7348 18.0002 11.4805 18.1055 11.293 18.293L9.155 20.43L7.832 18.445C7.7499 18.322 7.64151 18.2187 7.51467 18.1425C7.38782 18.0664 7.24567 18.0194 7.09846 18.0049C6.95125 17.9903 6.80265 18.0086 6.66337 18.0585C6.52408 18.1083 6.39759 18.1884 6.293 18.293L5 19.586V4C5 3.73478 5.10536 3.48043 5.29289 3.29289C5.48043 3.10536 5.73478 3 6 3H18C18.2652 3 18.5196 3.10536 18.7071 3.29289C18.8946 3.48043 19 3.73478 19 4V19.586Z" fill="#BDBDBD"/>
							<path d="M12 10H8C7.73478 10 7.48043 10.1054 7.29289 10.2929C7.10536 10.4804 7 10.7348 7 11C7 11.2652 7.10536 11.5196 7.29289 11.7071C7.48043 11.8946 7.73478 12 8 12H12C12.2652 12 12.5196 11.8946 12.7071 11.7071C12.8946 11.5196 13 11.2652 13 11C13 10.7348 12.8946 10.4804 12.7071 10.2929C12.5196 10.1054 12.2652 10 12 10Z" fill="#BDBDBD"/>
							<path d="M12 14H8C7.73478 14 7.48043 14.1054 7.29289 14.2929C7.10536 14.4804 7 14.7348 7 15C7 15.2652 7.10536 15.5196 7.29289 15.7071C7.48043 15.8947 7.73478 16 8 16H12C12.2652 16 12.5196 15.8947 12.7071 15.7071C12.8946 15.5196 13 15.2652 13 15C13 14.7348 12.8946 14.4804 12.7071 14.2929C12.5196 14.1054 12.2652 14 12 14Z" fill="#BDBDBD"/>
							<path d="M16 10H15C14.7348 10 14.4804 10.1054 14.2929 10.2929C14.1054 10.4804 14 10.7348 14 11C14 11.2652 14.1054 11.5196 14.2929 11.7071C14.4804 11.8946 14.7348 12 15 12H16C16.2652 12 16.5196 11.8946 16.7071 11.7071C16.8946 11.5196 17 11.2652 17 11C17 10.7348 16.8946 10.4804 16.7071 10.2929C16.5196 10.1054 16.2652 10 16 10Z" fill="#BDBDBD"/>
							<path d="M16 14H15C14.7348 14 14.4804 14.1054 14.2929 14.2929C14.1054 14.4804 14 14.7348 14 15C14 15.2652 14.1054 15.5196 14.2929 15.7071C14.4804 15.8947 14.7348 16 15 16H16C16.2652 16 16.5196 15.8947 16.7071 15.7071C16.8946 15.5196 17 15.2652 17 15C17 14.7348 16.8946 14.4804 16.7071 14.2929C16.5196 14.1054 16.2652 14 16 14Z" fill="#BDBDBD"/>
							<path d="M16 5H8C7.73478 5 7.48043 5.10536 7.29289 5.29289C7.10536 5.48043 7 5.73478 7 6C7 6.26521 7.10536 6.51957 7.29289 6.7071C7.48043 6.89464 7.73478 7 8 7H16C16.2652 7 16.5196 6.89464 16.7071 6.7071C16.8946 6.51957 17 6.26521 17 6C17 5.73478 16.8946 5.48043 16.7071 5.29289C16.5196 5.10536 16.2652 5 16 5Z" fill="#BDBDBD"/>
						</svg>
					</span>
					<span>Transactions</span>
				</a>
			</li>




			<li>
				<a class="nav-link" href="profile.php">
					<span class="dz-icon">
						<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<g clip-path="url(#clip0_329_300)">
							<path d="M15.7 11.7171C16.6839 10.9477 17.4031 9.89048 17.7575 8.69283C18.1118 7.49518 18.0836 6.21681 17.6767 5.03597C17.2698 3.85513 16.5046 2.8307 15.4877 2.10553C14.4708 1.38036 13.253 0.990601 12.004 0.990601C10.755 0.990601 9.53719 1.38036 8.52031 2.10553C7.50342 2.8307 6.73819 3.85513 6.33131 5.03597C5.92443 6.21681 5.89619 7.49518 6.25053 8.69283C6.60487 9.89048 7.32413 10.9477 8.308 11.7171C6.44917 12.4567 4.85467 13.7364 3.73027 15.3911C2.60587 17.0458 2.00318 18.9995 2 21.0001V22.0001C2 22.2653 2.10536 22.5196 2.29289 22.7072C2.48043 22.8947 2.73478 23.0001 3 23.0001H21C21.2652 23.0001 21.5196 22.8947 21.7071 22.7072C21.8946 22.5196 22 22.2653 22 22.0001V21.0001C21.9975 19.0004 21.3959 17.0474 20.273 15.3928C19.1501 13.7382 17.5573 12.4579 15.7 11.7171V11.7171ZM8 7.00007C8 6.20895 8.2346 5.43559 8.67412 4.77779C9.11365 4.12 9.73836 3.60731 10.4693 3.30456C11.2002 3.00181 12.0044 2.92259 12.7804 3.07693C13.5563 3.23128 14.269 3.61224 14.8284 4.17165C15.3878 4.73106 15.7688 5.44379 15.9231 6.21971C16.0775 6.99564 15.9983 7.7999 15.6955 8.53081C15.3928 9.26171 14.8801 9.88642 14.2223 10.3259C13.5645 10.7655 12.7911 11.0001 12 11.0001C10.9391 11.0001 9.92172 10.5786 9.17157 9.8285C8.42143 9.07835 8 8.06094 8 7.00007ZM4 21.0001C4 18.8783 4.84285 16.8435 6.34315 15.3432C7.84344 13.8429 9.87827 13.0001 12 13.0001C14.1217 13.0001 16.1566 13.8429 17.6569 15.3432C19.1571 16.8435 20 18.8783 20 21.0001H4Z" fill="#B0ACB3"/>
							</g>
							<defs>
							<clipPath id="clip0_329_300">
							<rect width="24" height="24" fill="white"/>
							</clipPath>
							</defs>
						</svg>
					</span>
					<span>Profile</span>
				</a>
			</li>
			<li>
				<a class="nav-link" href="logout.php">
					<span class="dz-icon">
						<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M16.65 3.10008C16.5318 3.04157 16.4033 3.00692 16.2717 2.9981C16.1401 2.98928 16.0081 3.00646 15.8831 3.04866C15.7582 3.09087 15.6428 3.15727 15.5435 3.24407C15.4442 3.33088 15.363 3.43639 15.3045 3.55458C15.246 3.67277 15.2114 3.80132 15.2025 3.9329C15.1937 4.06448 15.2109 4.19652 15.2531 4.32146C15.2953 4.4464 15.3617 4.5618 15.4485 4.66108C15.5353 4.76036 15.6408 4.84157 15.759 4.90008C17.4682 5.74788 18.8405 7.14857 19.6532 8.87467C20.4659 10.6008 20.6712 12.5509 20.2358 14.4084C19.8004 16.2659 18.7499 17.9217 17.2548 19.1069C15.7597 20.292 13.9079 20.937 12 20.937C10.0922 20.937 8.24035 20.292 6.74526 19.1069C5.25018 17.9217 4.19964 16.2659 3.76424 14.4084C3.32885 12.5509 3.53417 10.6008 4.34687 8.87467C5.15956 7.14857 6.5319 5.74788 8.24102 4.90008C8.47972 4.78192 8.6617 4.57379 8.74694 4.32146C8.83217 4.06913 8.81368 3.79327 8.69553 3.55458C8.57737 3.31588 8.36924 3.1339 8.11691 3.04866C7.86458 2.96343 7.58872 2.98192 7.35002 3.10008C5.23724 4.14875 3.54096 5.88079 2.5366 8.01498C1.53223 10.1492 1.27875 12.5602 1.81731 14.8566C2.35587 17.153 3.65485 19.2 5.50334 20.6651C7.35184 22.1302 9.64131 22.9275 12 22.9275C14.3587 22.9275 16.6482 22.1302 18.4967 20.6651C20.3452 19.2 21.6442 17.153 22.1827 14.8566C22.7213 12.5602 22.4678 10.1492 21.4635 8.01498C20.4591 5.88079 18.7628 4.14875 16.65 3.10008V3.10008Z" fill="#FF8484"/>
							<path d="M12 13.0001C12.2652 13.0001 12.5196 12.8948 12.7071 12.7072C12.8947 12.5197 13 12.2654 13 12.0001V2.00012C13 1.73491 12.8947 1.48055 12.7071 1.29302C12.5196 1.10548 12.2652 1.00012 12 1.00012C11.7348 1.00012 11.4804 1.10548 11.2929 1.29302C11.1054 1.48055 11 1.73491 11 2.00012V12.0001C11 12.2654 11.1054 12.5197 11.2929 12.7072C11.4804 12.8948 11.7348 13.0001 12 13.0001Z" fill="#FF8484"/>
						</svg>
					</span>
					<span>Logout</span>
				</a>
			</li>
		</ul>

    </div>
	<!-- Sidebar End -->

	<!-- Nav Floting Start -->
	<div class="dz-nav-floting">
		<!-- Header -->
		<header class="header py-2 mx-auto">
			<div class="header-content">
			      <?php

                       include "dbconnect.php"; // Using database connection file here
                       $email = $_SESSION["email"];

                       $records = mysqli_query($conn,"select * from users where email='$email'");


                       // fetch data from database

                       while($data = mysqli_fetch_array($records))
                       {
                       ?>
				<div class="left-content">
					<div class="info">
						<p class="text m-b10"><?php 
$dat = new DateTime('now', new DateTimeZone('Africa/Gaborone'));
$date=$dat->format('H');
if($date < 12) 
  echo "Good morning"; 
else if($date < 17) 
  echo "Good afternoon";
else if($date<20)
  echo "Good evening"; 
else 
  echo "Good night"; 
?></p>
						<h3 class="title"><?php echo $data['first_name']; ?></h3>
					</div>
				</div>
				<div class="mid-content"></div>
				<div class="right-content d-flex align-items-center gap-4">
					<a href="#" class="notification-badge font-20 badge-active">
						<svg width="30" height="30" viewBox="0 0 24 24" class="svg-primary" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M21.7329 21.68C21.8273 21.5791 21.8998 21.4597 21.9457 21.3295C21.9917 21.1992 22.0101 21.0608 21.9999 20.923L20.9999 7.92299C20.9805 7.67134 20.8666 7.43634 20.6811 7.26515C20.4957 7.09396 20.2523 6.99924 19.9999 6.99999H16.9999C16.9999 5.67391 16.4731 4.40214 15.5355 3.46446C14.5978 2.52677 13.326 1.99999 11.9999 1.99999C10.6738 1.99999 9.40207 2.52677 8.46438 3.46446C7.5267 4.40214 6.99992 5.67391 6.99992 6.99999H3.99992C3.74752 6.99924 3.50417 7.09396 3.3187 7.26515C3.13323 7.43634 3.01935 7.67134 2.99992 7.92299L1.99992 20.923C1.98929 21.0606 2.00727 21.199 2.05275 21.3294C2.09822 21.4597 2.17019 21.5792 2.26413 21.6804C2.35807 21.7816 2.47194 21.8622 2.59858 21.9172C2.72521 21.9722 2.86186 22.0004 2.99992 22H20.9999C21.1375 22 21.2737 21.9715 21.3998 21.9165C21.5259 21.8614 21.6393 21.7809 21.7329 21.68ZM11.9999 3.99999C12.7956 3.99999 13.5586 4.31606 14.1212 4.87867C14.6838 5.44128 14.9999 6.20434 14.9999 6.99999H8.99992C8.99992 6.20434 9.31599 5.44128 9.8786 4.87867C10.4412 4.31606 11.2043 3.99999 11.9999 3.99999ZM4.07992 20L4.92592 8.99999H6.99992V11C6.99992 11.2652 7.10527 11.5196 7.29281 11.7071C7.48035 11.8946 7.7347 12 7.99992 12C8.26513 12 8.51949 11.8946 8.70702 11.7071C8.89456 11.5196 8.99992 11.2652 8.99992 11V8.99999H14.9999V11C14.9999 11.2652 15.1053 11.5196 15.2928 11.7071C15.4803 11.8946 15.7347 12 15.9999 12C16.2651 12 16.5195 11.8946 16.707 11.7071C16.8946 11.5196 16.9999 11.2652 16.9999 11V8.99999H19.0739L19.9199 20H4.07992Z" fill="#04764E"></path>
						</svg>
					</a>
					<a href="javascript:void(0);" class="icon dz-floating-toggler">
						<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<rect y="2" width="20" height="3" rx="1.5" fill="#5F5F5F"/>
							<rect y="18" width="20" height="3" rx="1.5" fill="#5F5F5F"/>
							<rect x="4" y="10" width="20" height="3" rx="1.5" fill="#5F5F5F"/>
						</svg>
					</a>
				</div>
				
		            <?php
                    }
                    ?>
			</div>
		</header>
		<!-- Header -->
		
		<!-- Main Content Start -->
		<main class="page-content bg-white p-b60">
			<div class="container">
				<!-- SearchBox -->
				<div class="search-box">
					<div class="input-group input-radius input-rounded input-lg">
						<input type="text" placeholder="Search Tuckshop" class="form-control">
						<span class="input-group-text">
							<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M9.65925 19.3102C11.8044 19.3103 13.8882 18.5946 15.5806 17.2764L21.9653 23.6612C22.4423 24.1218 23.2023 24.1086 23.663 23.6316C24.1123 23.1664 24.1123 22.4288 23.663 21.9635L17.2782 15.5788C20.5491 11.3682 19.7874 5.30333 15.5769 2.03243C11.3663 -1.23848 5.30149 -0.476799 2.03058 3.73374C-1.24033 7.94428 -0.478646 14.0092 3.73189 17.2801C5.42702 18.5969 7.51269 19.3113 9.65925 19.3102ZM4.52915 4.5273C7.36245 1.69394 11.9561 1.69389 14.7895 4.5272C17.6229 7.3605 17.6229 11.9542 14.7896 14.7876C11.9563 17.6209 7.36261 17.621 4.52925 14.7877C4.5292 14.7876 4.5292 14.7876 4.52915 14.7876C1.69584 11.9749 1.67915 7.39794 4.49181 4.56464C4.50424 4.55216 4.51667 4.53973 4.52915 4.5273Z" fill="#C9C9C9"/>
							</svg>
						</span>
					</div>
				</div>
				<!-- SearchBox -->
				
				<!-- Overlay Card -->

				<!-- Overlay Card -->
				
			
			


				<!-- Featured Beverages -->
				<div class="title-bar">
					<h5 class="title" text-align="center">Available Tuck Shops</h5>
				
				</div>
				
				<ul class="featured-list">
					<li>
						<div class="dz-card list">
						
						   <div class="container ">
        <div class="row ">
            <!-- Item 1 -->
            <div class="col-md-2">
                <div class="card">
                    
                    <div class="group-container">
                                     <?php

                       include "dbconnect.php"; // Using database connection file here
                       $email = $_SESSION["email"];
                       $type="Owner";

                                                           $records = mysqli_query($conn,"select * from users where type ='$type'and tuckshop_name is not null");


                       // fetch data from database

                       while($data = mysqli_fetch_array($records))
                       {
                       ?>
                        <ul class="list-group">
    <li class="list-group-item"><img src="tucky.png" alt="" style="width:50%; height:180px;"></li>
    <li class="list-group-item">Tuck Shop Name: <?php echo $data['tuckshop_name']; ?></li>
    <li class="list-group-item">Address :<?php echo $data['address']; ?></li>
    
  
</ul>

      <a href="tuckshop.php?email=<?echo $data["email"];?>"><button class="btn btn-primary" >Slide In</button></a> 


                        
                      <?php
                    }
                    ?>  
                        
                    
                    </div>
                </div>
            </div>

        </div>
        </div>
														
		            
						</div>
					</li>
			
			
				
				</ul>
				<!-- Featured Beverages -->
			</div>
		</main>
		<!-- Main Content End -->
		
		<!-- Menubar -->
		<div class="menubar-area footer-fixed">
			<div class="toolbar-inner menubar-nav">
				<a href="index.php" class="nav-link active">
					<i class="fi fi-rr-home"></i>
				</a>
				<a href="#" class="nav-link">
					<i class="fi fi-rr-shopping-bag"></i>
				</a>
				<a href="#" class="nav-link">
					<i class="fi fi-rr-shopping-cart"></i>
				</a>
				<a href="profile.php" class="nav-link">
					<i class="fi fi-rr-user"></i>
				</a>
			</div>
		</div>
		<!-- Menubar -->
	</div>
	<!-- Nav Floting End -->
	
	<!-- Modal -->

	<!-- PWA End --> 
	
	    <!-- Modal -->
    <div class="modal fade" id="purchaseModal" tabindex="-1" aria-labelledby="purchaseModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="purchaseModalLabel">Purchase Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Form with dynamic PHP values -->
                    <form action="credit.php" method="POST">
                        <div class="mb-3">
                            <label for="itemName" class="form-label">Item ID</label>
                            <input type="text" id="itemId" name="itemId" class="form-control" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="itemName" class="form-label">Item</label>
                            <input type="text" id="itemName" name="itemName" class="form-control" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="itemPrice" class="form-label">Price</label>
                            <input type="text" id="itemPrice" name="itemPrice" class="form-control" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label">Email Address</label>
                            <input type="text" id="buyerEmail" name="bemail" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label for="itemPrice" class="form-label">Quantity</label>
                            <input type="number" id="quantity" name="quantity" class="form-control" required>
                        </div>
                        <button type="submit" name="submit" class="btn btn-success">Confirm Request</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
	
	
	
</div>  
<!--**********************************
    Scripts
***********************************-->

 <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // JavaScript function to set modal values dynamically
        function setItemDetails(id,name, price,email) {
            document.getElementById('itemId').value = id;
            document.getElementById('itemName').value = name;
            document.getElementById('itemPrice').value = price;
           
            document.getElementById('buyerEmail').value = email;
        }
    </script>


<script src="assets/js/jquery.js"></script>
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/swiper/swiper-bundle.min.js"></script>
<script src="assets/js/dz.carousel.js"></script>
<script src="assets/js/settings.js"></script>
<script src="assets/js/custom.js"></script>
<script src="index.js"></script>
</body>

<!-- Mirrored from ombe.dexignzone.com/bootstrap/xhtml/index.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 11 Mar 2025 08:40:57 GMT -->
</html>